from typing import Annotated
from typing import TypeGuard
from typing import get_args
from typing import get_origin

from imbue_core.sculptor.state.messages import Message
from sculptor.interfaces.agents.agent import UserMessageUnion


def _get_user_message_union_types() -> tuple[type, ...]:
    """Extract all concrete types from UserMessageUnion for isinstance() checks."""

    union_args = get_args(UserMessageUnion)
    actual_types = []

    for arg in union_args:
        # Handle Annotated types (e.g., Annotated[ChatInputUserMessage, Tag("ChatInputUserMessage")])
        if get_origin(arg) is Annotated:
            actual_types.append(get_args(arg)[0])
        else:
            actual_types.append(arg)

    return tuple(actual_types)


def is_user_message(message: Message) -> TypeGuard[UserMessageUnion]:
    return isinstance(message, _get_user_message_union_types())
