"""Constants shared by the Sculptor project"""

import os
from enum import StrEnum
from pathlib import Path

ROOT_PATH = Path("/imbue_addons")

# Should be in sync with imbue_core.thread_utils.EXIT_CODE_IRRECOVERABLE_ERROR
SCULPTOR_EXIT_CODE_IRRECOVERABLE_ERROR = 3
SCULPTOR_EXIT_CODE_PARENT_DIED = 4
SCULPTOR_EXIT_CODE_COULD_NOT_ACQUIRE_LOCK = 5


def existing_snapshots_path() -> str | None:
    """If this environment variable is set, the proxy was initialized with existing collection of snapshots.

    We must not call remote servers if this is true."""
    return os.environ.get("SNAPSHOT_PATH", None)


maybe_existing_snapshots_path = existing_snapshots_path()
PROXY_CACHE_PATH = (
    str(ROOT_PATH / ".proxy_cache.db") if maybe_existing_snapshots_path is None else maybe_existing_snapshots_path
)


class ElementIDs(StrEnum):
    """Specific tags added to frontend HTML that can be used to find specific elements."""

    # Home Page Elements
    # Task Starter
    TASK_STARTER = "TASK_STARTER"
    TASK_INPUT = "TASK_INPUT"
    START_TASK_BUTTON = "START_TASK_BUTTON"
    BRANCH_SELECTOR = "BRANCH_SELECTOR"
    DISABLED_BRANCH_SELECTOR = "DISABLED_BRANCH_SELECTOR"
    BRANCH_OPTION = "BRANCH_OPTION"
    REPO_INDICATOR = "REPO_INDICATOR"
    HOME_PAGE_SYSTEM_PROMPT_OPEN_BUTTON = "HOME_PAGE_SYSTEM_PROMPT_OPEN_BUTTON"
    HOME_PAGE_SYSTEM_PROMPT_INPUT = "HOME_PAGE_SYSTEM_PROMPT_INPUT"
    HOME_PAGE_SYSTEM_PROMPT_SAVE_BUTTON = "HOME_PAGE_SYSTEM_PROMPT_SAVE_BUTTON"
    VERSION = "VERSION"

    # Sidebar Elements
    TOGGLE_SIDEBAR_BUTTON = "TOGGLE_SIDEBAR_BUTTON"
    SIDEBAR = "SIDEBAR"
    HOME_BUTTON = "HOME_BUTTON"
    NEW_AGENT_BUTTON = "NEW_AGENT_BUTTON"
    VIEW_ARCHIVED_TASKS_BUTTON = "VIEW_ARCHIVED_TASKS_BUTTON"
    BACK_TO_ACTIVE_AGENTS_BUTTON = "BACK_TO_ACTIVE_AGENTS_BUTTON"
    SETTINGS_BUTTON = "SETTINGS_BUTTON"

    # Project Selector
    PROJECT_SELECTOR = "PROJECT_SELECTOR"
    PROJECT_SELECT_ITEM = "PROJECT_SELECT_ITEM"
    OPEN_NEW_REPO_BUTTON = "OPEN_NEW_REPO_BUTTON"
    OPEN_NEW_REPO_DIALOG = "OPEN_NEW_REPO_DIALOG"
    OPEN_NEW_REPO_INPUT = "OPEN_NEW_REPO_INPUT"
    CONFIRM_OPEN_NEW_REPO_BUTTON = "CONFIRM_OPEN_NEW_REPO_BUTTON"
    CANCEL_OPEN_NEW_REPO_BUTTON = "CANCEL_OPEN_NEW_REPO_BUTTON"

    # Task List and Task Item
    TASK_LIST = "TASK_LIST"
    TASK_STATUS = "TASK_STATUS"
    TASK_BRANCH = "TASK_BRANCH"
    TASK_BUTTON = "TASK_BUTTON"
    TASK_TITLE = "TASK_TITLE"
    TASK_ACTIONS_MENU_BUTTON = "TASK_ACTIONS_MENU_BUTTON"
    ARCHIVE_MENU_ITEM = "ARCHIVE_MENU_ITEM"
    RESTORE_MENU_ITEM = "RESTORE_MENU_ITEM"
    DELETE_MENU_ITEM = "DELETE_MENU_ITEM"
    CONFIRM_DELETE_BUTTON = "CONFIRM_DELETE_BUTTON"

    # Chat Page Elements
    # Task Header
    TASK_HEADER = "TASK_HEADER"
    BRANCH_NAME = "BRANCH_NAME"
    MCP_SERVERS_BUTTON = "MCP_SERVERS_BUTTON"
    MCP_SERVERS_MODAL = "MCP_SERVERS_MODAL"

    MERGE_PANEL_BUTTON = "MERGE_PANEL_BUTTON"
    MERGE_PANEL_CONTENT = "MERGE_PANEL_CONTENT"
    MERGE_PANEL_BRANCH_SELECTOR = "MERGE_PANEL_BRANCH_SELECTOR"
    MERGE_PANEL_BRANCH_OPTIONS = "MERGE_PANEL_BRANCH_OPTIONS"
    MERGE_PANEL_PUSH_BUTTON = "MERGE_PANEL_PUSH_BUTTON"
    MERGE_PANEL_PULL_OR_FETCH_BUTTON = "MERGE_PANEL_PULL_OR_FETCH_BUTTON"
    MERGE_PANEL_FOOTER_NOTICES = "MERGE_PANEL_FOOTER_NOTICES"
    MERGE_PANEL_DIALOG_COMMIT_MESSAGE_INPUT = "MERGE_PANEL_DIALOG_COMMIT_MESSAGE_INPUT"

    GIT_COMMIT_MESSAGE_INPUT = "GIT_COMMIT_MESSAGE_INPUT"
    GIT_COMMIT_BUTTON = "GIT_COMMIT_BUTTON"

    # BACK_TO_HOME_BUTTON removed - navigation now happens via sidebar

    # Task Modal
    TASK_MODAL = "TASK_MODAL"
    TASK_MODAL_INPUT = "TASK_MODAL_INPUT"
    TASK_MODAL_CREATE_TASK_BUTTON = "TASK_MODAL_CREATE_TASK_BUTTON"
    TASK_MODAL_FORK_TASK_BUTTON = "TASK_MODAL_FORK_TASK_BUTTON"
    TASK_MODAL_BRANCH_SELECTOR = "TASK_MODAL_BRANCH_SELECTOR"
    TASK_MODAL_DISABLED_BRANCH_SELECTOR = "TASK_MODAL_DISABLED_BRANCH_SELECTOR"
    TASK_MODAL_BRANCH_OPTION = "TASK_MODAL_BRANCH_OPTION"
    TASK_MODAL_SYSTEM_PROMPT_OPEN_BUTTON = "TASK_MODAL_SYSTEM_PROMPT_OPEN_BUTTON"
    TASK_MODAL_SYSTEM_PROMPT_SAVE_BUTTON = "TASK_MODAL_SYSTEM_PROMPT_SAVE_BUTTON"
    TASK_MODAL_SYSTEM_PROMPT_CANCEL_BUTTON = "TASK_MODAL_SYSTEM_PROMPT_CANCEL_BUTTON"
    TASK_MODAL_MODEL_SELECTOR = "TASK_MODAL_MODEL_SELECTOR"
    TASK_MODAL_CLOSE_BUTTON = "TASK_MODAL_CLOSE_BUTTON"
    TASK_MODAL_CREATE_MORE_TOGGLE = "TASK_MODAL_CREATE_MORE_TOGGLE"

    # Forking
    FORKED_TO_BLOCK = "FORKED_TO_BLOCK"
    FORKED_FROM_BLOCK = "FORKED_FROM_BLOCK"
    FORK_BUTTON = "FORK_BUTTON"
    FORK_BUTTON_SPINNER = "FORK_BUTTON_SPINNER"
    FORK_BUTTON_NOT_POSSIBLE = "FORK_BUTTON_NOT_POSSIBLE"
    FORK_BLOCK_BUTTON = "FORK_BLOCK_BUTTON"

    # Search Modal
    SEARCH_MODAL_OPEN_BUTTON = "SEARCH_MODAL_OPEN_BUTTON"
    SEARCH_MODAL = "SEARCH_MODAL"
    SEARCH_MODAL_INPUT = "SEARCH_MODAL_INPUT"
    SEARCH_MODAL_TASK_LIST = "SEARCH_MODAL_TASK_LIST"
    SEARCH_MODAL_TASK_ITEM = "SEARCH_MODAL_TASK_ITEM"
    SEARCH_MODAL_NO_TASKS = "SEARCH_MODAL_NO_TASKS"
    SEARCH_MODAL_CLOSE_BUTTON = "SEARCH_MODAL_CLOSE_BUTTON"

    # Chat Panel
    CHAT_PANEL = "CHAT_PANEL"
    CHAT_PANEL_MESSAGE = "CHAT_PANEL_MESSAGE"
    USER_MESSAGE = "USER_MESSAGE"
    ASSISTANT_MESSAGE = "ASSISTANT_MESSAGE"
    DELETE_QUEUED_MESSAGE_BUTTON = "DELETE_QUEUED_MESSAGE_BUTTON"
    QUEUED_MESSAGE_CARD = "QUEUED_MESSAGE_CARD"
    TOOL_HEADER = "TOOL_HEADER"
    NO_ACTION_OUTPUTS = "NO_ACTION_OUTPUTS"
    ERROR_BLOCK = "ERROR_BLOCK"
    ERROR_BLOCK_RETRY_BUTTON = "ERROR_BLOCK_RETRY_BUTTON"
    SNAPSHOT_MESSAGE = "SNAPSHOT_MESSAGE"

    CHAT_INPUT = "CHAT_INPUT"
    SEND_BUTTON = "SEND_BUTTON"
    STOP_BUTTON = "STOP_BUTTON"
    STOP_BUTTON_SPINNER = "STOP_BUTTON_SPINNER"
    TOOL_CALL = "TOOL_CALL"
    CHAT_PANEL_SYSTEM_PROMPT_OPEN_BUTTON = "CHAT_PANEL_SYSTEM_PROMPT_OPEN_BUTTON"
    CHAT_PANEL_SYSTEM_PROMPT_TEXT = "CHAT_PANEL_SYSTEM_PROMPT_TEXT"
    CHAT_PANEL_SYSTEM_PROMPT_SAVE_BUTTON = "CHAT_PANEL_SYSTEM_PROMPT_SAVE_BUTTON"
    MODEL_SELECTOR = "MODEL_SELECTOR"
    MODEL_OPTION = "MODEL_OPTION"
    CONTEXT_SUMMARY = "CONTEXT_SUMMARY"
    CONTEXT_SUMMARY_HEADER = "CONTEXT_SUMMARY_HEADER"
    RESUME_RESPONSE = "RESUME_RESPONSE"
    COMPACTION_BUTTON = "COMPACTION_BUTTON"
    COMPACTION_PANEL = "COMPACTION_PANEL"
    COMPACTION_BAR = "COMPACTION_BAR"

    FILE_PREVIEW_LIST = "FILE_PREVIEW_LIST"
    FILE_PREVIEW = "FILE_PREVIEW"
    FILE_PREVIEW_REMOVE = "FILE_PREVIEW_REMOVE"
    FILE_PREVIEW_CONTAINER = "FILE_PREVIEW_CONTAINER"
    FILE_UPLOAD = "FILE_UPLOAD"

    MESSAGE_ACTION_BAR = "MESSAGE_ACTION_BAR"
    THUMBS_UP_BUTTON = "THUMBS_UP_BUTTON"
    THUMBS_DOWN_BUTTON = "THUMBS_DOWN_BUTTON"
    FEEDBACK_DIALOG = "FEEDBACK_DIALOG"
    FEEDBACK_DIALOG_CANCEL_BUTTON = "FEEDBACK_DIALOG_CANCEL_BUTTON"
    FEEDBACK_DIALOG_SUBMIT_BUTTON = "FEEDBACK_DIALOG_SUBMIT_BUTTON"
    FEEDBACK_DIALOG_ISSUE_TYPE_DROPDOWN = "FEEDBACK_DIALOG_ISSUE_TYPE_DROPDOWN"

    # Artifact Panel
    ARTIFACT_PANEL = "ARTIFACT_PANEL"

    ARTIFACT_DIFF_TAB = "ARTIFACT_DIFF_TAB"
    ARTIFACT_DIFF_SECTION = "ARTIFACT_DIFF_SECTION"
    ARTIFACT_UNCOMMITTED_SECTION = "ARTIFACT_UNCOMMITTED_SECTION"
    ARTIFACT_COMMITTED_SECTION = "ARTIFACT_COMMITTED_SECTION"
    ARTIFACT_FILE = "ARTIFACT_FILE"
    ARTIFACT_FILE_HEADER = "ARTIFACT_FILE_HEADER"
    ARTIFACT_FILE_DROPDOWN = "ARTIFACT_FILE_DROPDOWN"
    ARTIFACT_FILE_BODY = "ARTIFACT_FILE_BODY"
    ARTIFACT_FILE_NAME = "ARTIFACT_FILE_NAME"
    ARTIFACT_COMMITTED_SECTION_EXPAND = "ARTIFACT_COMMITTED_SECTION_EXPAND"
    ARTIFACT_COMBINEDDIFF_TAB = "ARTIFACT_COMBINEDDIFF_TAB"
    ARTIFACT_COMBINEDDIFF_SECTION = "ARTIFACT_COMBINEDDIFF_SECTION"

    ARTIFACT_PLAN_TAB = "ARTIFACT_TODOLIST_TAB"
    ARTIFACT_PLAN_SECTION = "ARTIFACT_TODOLIST_SECTION"
    ARTIFACT_PLAN_ITEM = "ARTIFACT_PLAN_ITEM"
    ARTIFACT_PLAN_CHECKMARK = "ARTIFACT_PLAN_CHECKMARK"
    ARTIFACT_SUGGESTIONS_TAB = "ARTIFACT_SUGGESTIONS_TAB"

    # Common UI Elements
    TOAST = "TOAST"
    TOAST_CLOSE_BUTTON = "TOAST_CLOSE_BUTTON"

    # These show up in multiple places
    SYNC_BUTTON = "SYNC_BUTTON"
    SYNC_BUTTON_TOOLTIP = "SYNC_BUTTON_TOOLTIP"
    SYNC_BUTTON_DROPDOWN = "SYNC_BUTTON_DROPDOWN"

    # Onboarding page
    ONBOARDING_WELCOME_STEP = "ONBOARDING_WELCOME_STEP"
    ONBOARDING_EMAIL_INPUT = "ONBOARDING_EMAIL_INPUT"
    ONBOARDING_FULL_NAME_INPUT = "ONBOARDING_FULL_NAME_INPUT"
    ONBOARDING_EMAIL_SUBMIT = "ONBOARDING_EMAIL_SUBMIT"
    ONBOARDING_TELEMETRY_RADIO_GROUP = "ONBOARDING_TELEMETRY_RADIO_GROUP"
    ONBOARDING_INSTALLATION_STEP = "ONBOARDING_INSTALLATION_STEP"
    ONBOARDING_ANTHROPIC_ACCESS_MODAL_OPEN_BUTTON = "ONBOARDING_ANTHROPIC_ACCESS_MODAL_OPEN_BUTTON"
    ONBOARDING_ANTHROPIC_ACCESS_MODAL = "ONBOARDING_ANTHROPIC_ACCESS_MODAL"
    ONBOARDING_API_KEY_MODAL_OPEN_BUTTON = "ONBOARDING_API_KEY_MODAL_OPEN_BUTTON"
    ONBOARDING_API_KEY_MODAL = "ONBOARDING_API_KEY_MODAL"
    ONBOARDING_API_KEY_INPUT = "ONBOARDING_API_KEY_INPUT"
    ONBOARDING_API_KEY_SUBMIT = "ONBOARDING_API_KEY_SUBMIT"
    ONBOARDING_TELEMETRY_SELECTOR = "ONBOARDING_TELEMETRY_SELECTOR"
    ONBOARDING_TELEMETRY_OPTION = "ONBOARDING_TELEMETRY_OPTION"
    ONBOARDING_COMPLETE_BUTTON = "ONBOARDING_COMPLETE_BUTTON"
    ONBOARDING_BACK_BUTTON = "ONBOARDING_BACK_BUTTON"

    # Project selector page
    SELECT_PROJECT_PAGE = "SELECT_PROJECT_PAGE"
    PROJECT_PATH_INPUT = "PROJECT_PATH_INPUT"
    PROJECT_SELECT_BUTTON = "PROJECT_SELECT_BUTTON"
    PROJECT_GIT_INIT_DIALOG = "PROJECT_GIT_INIT_DIALOG"
    PROJECT_GIT_INIT_CONFIRM = "PROJECT_GIT_INIT_CONFIRM"
    PROJECT_GIT_INIT_CANCEL = "PROJECT_GIT_INIT_CANCEL"
    PROJECT_SELECTOR_ERROR = "PROJECT_SELECTOR_ERROR"
    PROJECT_INITIAL_COMMIT_DIALOG = "PROJECT_INITIAL_COMMIT_DIALOG"
    PROJECT_INITIAL_COMMIT_CONFIRM = "PROJECT_INITIAL_COMMIT_CONFIRM"
    PROJECT_INITIAL_COMMIT_CANCEL = "PROJECT_INITIAL_COMMIT_CANCEL"

    # Settings page
    SETTINGS_PAGE = "SETTINGS_PAGE"
    SETTINGS_CONTENT = "SETTINGS_CONTENT"
    SETTINGS_NAV_GENERAL = "SETTINGS_NAV_GENERAL"
    SETTINGS_NAV_KEYBINDINGS = "SETTINGS_NAV_KEYBINDINGS"
    SETTINGS_NAV_ACCOUNT = "SETTINGS_NAV_ACCOUNT"
    SETTINGS_NAV_EXPERIMENTAL = "SETTINGS_NAV_EXPERIMENTAL"
    SETTINGS_DEFAULT_MODEL_SELECT = "SETTINGS_DEFAULT_MODEL_SELECT"
    SETTINGS_DEFAULT_MODEL_OPTION = "SETTINGS_DEFAULT_MODEL_OPTION"
    SETTINGS_THEME_SELECT = "SETTINGS_THEME_SELECT"
    SETTINGS_TELEMETRY_SELECT = "SETTINGS_TELEMETRY_SELECT"
    SETTINGS_TELEMETRY_OPTION = "SETTINGS_TELEMETRY_OPTION"
    SETTINGS_ANTHROPIC_AUTH_BUTTON = "SETTINGS_ANTHROPIC_AUTH_BUTTON"
    SETTINGS_USE_INTERNAL_UPDATE_CHANNEL = "SETTINGS_USE_INTERNAL_UPDATE_CHANNEL"

    # Hotkey fields
    SETTINGS_GLOBAL_HOTKEY_FIELD = "SETTINGS_GLOBAL_HOTKEY_FIELD"
    SETTINGS_NEW_AGENT_HOTKEY_FIELD = "SETTINGS_NEW_AGENT_HOTKEY_FIELD"
    SETTINGS_SEARCH_AGENTS_HOTKEY_FIELD = "SETTINGS_SEARCH_AGENTS_HOTKEY_FIELD"
    SETTINGS_TOGGLE_SIDEBAR_HOTKEY_FIELD = "SETTINGS_TOGGLE_SIDEBAR_HOTKEY_FIELD"
    SETTINGS_HOTKEY_CLEAR_BUTTON = "SETTINGS_HOTKEY_CLEAR_BUTTON"
    SETTINGS_HOTKEY_SET_BUTTON = "SETTINGS_HOTKEY_SET_BUTTON"

    # Account fields
    SETTINGS_EMAIL_FIELD = "SETTINGS_EMAIL_FIELD"
    SETTINGS_GIT_USERNAME_FIELD = "SETTINGS_GIT_USERNAME_FIELD"
    SETTINGS_GIT_USERNAME_INPUT = "SETTINGS_GIT_USERNAME_INPUT"
    SETTINGS_GIT_USERNAME_EDIT_BUTTON = "SETTINGS_GIT_USERNAME_EDIT_BUTTON"
    SETTINGS_GIT_USERNAME_SAVE_BUTTON = "SETTINGS_GIT_USERNAME_SAVE_BUTTON"

    # Warning Status Banner
    WARNING_STATUS_BANNER = "WARNING_STATUS_BANNER"
    WARNING_STATUS_BANNER_LINK = "WARNING_STATUS_BANNER_LINK"

    # Project Path Dialog
    PROJECT_PATH_DIALOG = "PROJECT_PATH_DIALOG"
    PROJECT_PATH_DIALOG_CLOSE_BUTTON = "PROJECT_PATH_DIALOG_CLOSE_BUTTON"


class GatewayRemoteAPIEndpoints(StrEnum):
    GITLAB_ANONYMOUS_PAT_ENDPOINT = "/anonymous-gitlab-token"
