import subprocess

from loguru import logger


def test_pyre_type_checking() -> None:
    result = subprocess.run(
        ["uv", "run", "--project", "sculptor", "pyre", "--noninteractive", "--log-level=CRITICAL"],
        capture_output=True,
        text=True,
    )
    # stderr has debugging info; stdout has the identified errors
    logger.debug("pyre stderr:\n{}", result.stderr)
    logger.warning("pyre stdout:\n{}", result.stdout)
    assert result.returncode == 0, result.stdout
