"""remove ephemeral messages

Revision ID: e0d5fc28d54a
Revises: fec9f27c7f2e
Create Date: 2025-08-21 20:46:50.615017

"""

from typing import Sequence

from alembic import op

# revision identifiers, used by Alembic.
revision: str = "e0d5fc28d54a"
down_revision: str | None = "fec9f27c7f2e"
branch_labels: str | Sequence[str] | None = None
depends_on: str | Sequence[str] | None = None


def upgrade() -> None:
    """Upgrade schema."""
    # Get the database dialect
    bind = op.get_bind()
    dialect_name = bind.dialect.name

    ephemeral_types = (
        "ForkAgentUserMessage",
        "GitCommitAndPushUserMessage",
        "GitPullUserMessage",
        "InterruptProcessUserMessage",
        "MCPStateUpdateAgentMessage",
        "PartialResponseBlockAgentMessage",
        "PauseLocalSyncRunnerMessage",
        "RemoveQueuedMessageUserMessage",
        "ResumeLocalSyncRunnerMessage",
        "ServerReadyAgentMessage",
        "StartLocalSyncRunnerMessage",
        "StopLocalSyncRunnerMessage",
        "StreamingStderrAgentMessage",
        "TaskLifecycleRunnerMessage",
        "TaskStatusRunnerMessage",
        "UpdateLocalSyncRunnerMessage",
        "WarningRunnerMessage",
    )

    if dialect_name == "postgresql":
        # PostgreSQL uses ->> for JSON text extraction
        types_list = ", ".join(f"'{t}'" for t in ephemeral_types)
        op.execute(f"""
            DELETE FROM saved_agent_message
            WHERE message->>'object_type' IN ({types_list})
        """)
    else:
        # SQLite uses json_extract
        types_list = ", ".join(f"'{t}'" for t in ephemeral_types)
        op.execute(f"""
            DELETE FROM saved_agent_message
            WHERE json_extract(message, '$.object_type') IN ({types_list})
        """)


def downgrade() -> None:
    """Downgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    pass
    # ### end Alembic commands ###
