"""make environment created ephemeral

Revision ID: be4a0386b97c
Revises: 25a88656cd11
Create Date: 2025-09-22 11:07:14.629285

"""

from typing import Sequence

from alembic import op

# revision identifiers, used by Alembic.
revision: str = "be4a0386b97c"
down_revision: str | None = "25a88656cd11"
branch_labels: str | Sequence[str] | None = None
depends_on: str | Sequence[str] | None = None


def upgrade() -> None:
    """Upgrade schema."""
    bind = op.get_bind()
    dialect_name = bind.dialect.name
    if dialect_name == "postgresql":
        op.execute("""
            DELETE FROM saved_agent_message
            WHERE message->>'object_type' = 'EnvironmentCreatedRunnerMessage'
        """)
    else:
        op.execute("""
            DELETE FROM saved_agent_message
            WHERE json_extract(message, '$.object_type') = 'EnvironmentCreatedRunnerMessage'
        """)


def downgrade() -> None:
    """Downgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    pass
    # ### end Alembic commands ###
