"""remove updated artifact agent message

Revision ID: 25a88656cd11
Revises: 748938f056cb
Create Date: 2025-09-22 10:19:54.765874

"""

from typing import Sequence

from alembic import op

# revision identifiers, used by Alembic.
revision: str = "25a88656cd11"
down_revision: str | None = "748938f056cb"
branch_labels: str | Sequence[str] | None = None
depends_on: str | Sequence[str] | None = None


def upgrade() -> None:
    """Upgrade schema."""
    bind = op.get_bind()
    dialect_name = bind.dialect.name

    # Delete UpdatedArtifactAgentMessages that contain GitBranchAgentArtifact
    if dialect_name == "postgresql":
        # PostgreSQL uses ->> for JSON text extraction
        op.execute("""
            DELETE FROM saved_agent_message
            WHERE message->>'object_type' = 'UpdatedArtifactAgentMessage'
        """)
    else:
        # SQLite uses json_extract
        op.execute("""
            DELETE FROM saved_agent_message
            WHERE json_extract(message, '$.object_type') = 'UpdatedArtifactAgentMessage'
        """)


def downgrade() -> None:
    """Downgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    pass
    # ### end Alembic commands ###
