"""remove stop agent user message

Revision ID: bde63d1fb395
Revises: 2995f89f9123
Create Date: 2025-09-15 14:42:35.661712

"""

from typing import Sequence

from alembic import op

# revision identifiers, used by Alembic.
revision: str = "bde63d1fb395"
down_revision: str | None = "2995f89f9123"
branch_labels: str | Sequence[str] | None = None
depends_on: str | Sequence[str] | None = None


def upgrade() -> None:
    """Upgrade schema."""
    # Get the database dialect
    bind = op.get_bind()
    dialect_name = bind.dialect.name

    if dialect_name == "postgresql":
        # PostgreSQL uses ->> for JSON text extraction
        op.execute("""
            DELETE FROM saved_agent_message
            WHERE message->>'object_type' = 'StopAgentUserMessage'
        """)
    else:
        # SQLite uses json_extract
        op.execute("""
            DELETE FROM saved_agent_message
            WHERE json_extract(message, '$.object_type') = 'StopAgentUserMessage'
        """)


def downgrade() -> None:
    """Downgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    pass
    # ### end Alembic commands ###
