import json
from pathlib import Path

from imbue_core.secrets_utils import Secret
from sculptor.services.config_service.data_types import AWSBedrockApiKey
from sculptor.services.config_service.data_types import AnthropicApiKey
from sculptor.services.config_service.data_types import AnthropicCredentials
from sculptor.services.config_service.data_types import ClaudeOauthCredentials
from sculptor.services.config_service.data_types import Credentials


def populate_anthropic_credentials_file(path: Path, anthropic_credentials: AnthropicCredentials) -> None:
    path.parent.mkdir(parents=True, exist_ok=True)
    json_dict = Credentials(anthropic=anthropic_credentials).model_dump()
    if json_dict["anthropic"]["object_type"] == "AnthropicApiKey":
        assert isinstance(anthropic_credentials, AnthropicApiKey)
        json_dict["anthropic"]["anthropic_api_key"] = anthropic_credentials.anthropic_api_key.unwrap()
    elif json_dict["anthropic"]["object_type"] == "AWSBedrockApiKey":
        assert isinstance(anthropic_credentials, AWSBedrockApiKey)
        json_dict["anthropic"]["bedrock_api_key"] = anthropic_credentials.bedrock_api_key.unwrap()
    elif json_dict["anthropic"]["object_type"] == "ClaudeOauthCredentials":
        assert isinstance(anthropic_credentials, ClaudeOauthCredentials)
        json_dict["anthropic"]["refresh_token"] = anthropic_credentials.refresh_token.unwrap()
        json_dict["anthropic"]["access_token"] = anthropic_credentials.access_token.unwrap()
    else:
        raise ValueError(f"Unknown object type: {json_dict['anthropic']['object_type']}")
    path.write_text(json.dumps(json_dict))


def populate_anthropic_credentials_file_for_test(path: Path) -> None:
    populate_anthropic_credentials_file(path, AnthropicApiKey(anthropic_api_key=Secret("sk-ant-fake-api-key")))
