# Service hierarchy

The `sculptor` services, like the top level modules, are "layered" --
that is, each service may only depend on services that are "lower" in the hierarchy.

From the top level down, the services are:

- `local_sync_service`: manages local syncing between the user's local repo and the task repo clones
- `task_service`: manages tasks, including task execution, scheduling and outputs.
- `git_repo_service`: manages Git repositories, including cloning and pushing changes.
- `environment_service`: manages environments in which tasks and agents run.
- `project_service`: handles server project initialization, retrieval and switching.
- `data_model_service`: manages data models, including loading and saving data to and from the database.
- `config_service`: manages access to user configuration, credentials, and secrets for Sculptor and any installed agents.
