"""Support multiple Codex models

Revision ID: 7f7f3838aeea
Revises: 49ad5f191a6e
Create Date: 2025-12-03 17:01:44.285736

"""

from typing import Sequence

import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision: str = "7f7f3838aeea"
down_revision: str | None = "49ad5f191a6e"
branch_labels: str | Sequence[str] | None = None
depends_on: str | Sequence[str] | None = None


def upgrade() -> None:
    """Upgrade schema."""
    # Update all ChatInputUserMessage objects in saved_agent_message table
    # to change all models set to CODEX to GPT_5.1_CODEX

    # Get database connection
    conn = op.get_bind()

    # Query all saved_agent_message rows
    result = conn.execute(sa.text("SELECT snapshot_id, message FROM saved_agent_message"))

    # Process each row
    import json

    updates = []
    for row in result:
        snapshot_id = row[0]
        message_json = json.loads(row[1])

        # Check if this is a ChatInputUserMessage and model_name is CODEX
        if message_json.get("object_type") == "ChatInputUserMessage" and message_json.get("model_name") == "CODEX":
            # Update the model_name to GPT-5.1-CODEX
            message_json["model_name"] = "GPT-5.1-CODEX"
            updates.append({"snapshot_id": snapshot_id, "message": json.dumps(message_json)})

    # Apply updates if any
    if updates:
        conn.execute(
            sa.text("UPDATE saved_agent_message SET message = :message WHERE snapshot_id = :snapshot_id"), updates
        )


def downgrade() -> None:
    """Downgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    pass
    # ### end Alembic commands ###
