"""Initial

Revision ID: f522cdff22d8
Revises:
Create Date: 2025-06-25 10:13:47.565656

(HYNEK) Created by running `uv run alembic -x dburl=sqlite:///:memory: revision --autogenerate -m "Initial"`.

"""

from typing import Sequence

import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision: str = "f522cdff22d8"
down_revision: str | None = None
branch_labels: str | Sequence[str] | None = None
depends_on: str | Sequence[str] | None = None


def upgrade() -> None:
    """Upgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "organization",
        sa.Column("snapshot_id", sa.String(), nullable=False),
        sa.Column("created_at", sa.DateTime(timezone=True), nullable=False),
        sa.Column("object_id", sa.String(), nullable=False),
        sa.Column("name", sa.String(), nullable=False),
        sa.PrimaryKeyConstraint("snapshot_id"),
    )
    op.create_table(
        "organization_latest",
        sa.Column("created_at", sa.DateTime(timezone=True), nullable=False),
        sa.Column("object_id", sa.String(), nullable=False),
        sa.Column("name", sa.String(), nullable=False),
        sa.PrimaryKeyConstraint("object_id"),
    )
    op.create_table(
        "organization_membership_link",
        sa.Column("snapshot_id", sa.String(), nullable=False),
        sa.Column("created_at", sa.DateTime(timezone=True), nullable=False),
        sa.Column("object_id", sa.String(), nullable=False),
        sa.Column("user_id", sa.String(), nullable=False),
        sa.Column("organization_id", sa.String(), nullable=False),
        sa.Column("is_active", sa.Integer(), nullable=False),
        sa.PrimaryKeyConstraint("snapshot_id"),
    )
    op.create_table(
        "project",
        sa.Column("snapshot_id", sa.String(), nullable=False),
        sa.Column("created_at", sa.DateTime(timezone=True), nullable=False),
        sa.Column("object_id", sa.String(), nullable=False),
        sa.Column("organization_id", sa.String(), nullable=False),
        sa.Column("name", sa.String(), nullable=False),
        sa.Column("user_git_repo_url", sa.String(), nullable=True),
        sa.Column("our_git_repo_url", sa.String(), nullable=True),
        sa.Column("is_loggable", sa.Integer(), nullable=False),
        sa.PrimaryKeyConstraint("snapshot_id"),
    )
    op.create_table(
        "task",
        sa.Column("snapshot_id", sa.String(), nullable=False),
        sa.Column("created_at", sa.DateTime(timezone=True), nullable=False),
        sa.Column("object_id", sa.String(), nullable=False),
        sa.Column("organization_id", sa.String(), nullable=False),
        sa.Column("user_id", sa.String(), nullable=False),
        sa.Column("project_id", sa.String(), nullable=False),
        sa.Column("parent_task_id", sa.String(), nullable=True),
        sa.Column("input_data", sa.JSON(), nullable=False),
        sa.Column("max_seconds", sa.Float(), nullable=True),
        sa.Column("current_state", sa.JSON(), nullable=True),
        sa.Column("outcome", sa.String(), nullable=False),
        sa.Column("error", sa.JSON(), nullable=True),
        sa.Column("is_archived", sa.Integer(), nullable=False),
        sa.Column("is_deleted", sa.Integer(), nullable=False),
        sa.PrimaryKeyConstraint("snapshot_id"),
    )
    op.create_table(
        "user",
        sa.Column("snapshot_id", sa.String(), nullable=False),
        sa.Column("created_at", sa.DateTime(timezone=True), nullable=False),
        sa.Column("object_id", sa.String(), nullable=False),
        sa.Column("email", sa.String(), nullable=False),
        sa.Column("is_usage_data_enabled", sa.Integer(), nullable=False),
        sa.Column("allowed_product_logging", sa.String(), nullable=False),
        sa.Column("default_system_prompt", sa.String(), nullable=True),
        sa.PrimaryKeyConstraint("snapshot_id"),
    )
    op.create_table(
        "user_latest",
        sa.Column("created_at", sa.DateTime(timezone=True), nullable=False),
        sa.Column("object_id", sa.String(), nullable=False),
        sa.Column("email", sa.String(), nullable=False),
        sa.Column("is_usage_data_enabled", sa.Integer(), nullable=False),
        sa.Column("allowed_product_logging", sa.String(), nullable=False),
        sa.Column("default_system_prompt", sa.String(), nullable=True),
        sa.PrimaryKeyConstraint("object_id"),
        sa.UniqueConstraint("email", name="unique_user_email"),
    )
    op.create_table(
        "organization_membership_link_latest",
        sa.Column("created_at", sa.DateTime(timezone=True), nullable=False),
        sa.Column("object_id", sa.String(), nullable=False),
        sa.Column("user_id", sa.String(), nullable=False),
        sa.Column("organization_id", sa.String(), nullable=False),
        sa.Column("is_active", sa.Integer(), nullable=False),
        sa.ForeignKeyConstraint(
            ["organization_id"], ["organization_latest.object_id"], name="foreign_key_organization_id"
        ),
        sa.ForeignKeyConstraint(["user_id"], ["user_latest.object_id"], name="foreign_key_user_id"),
        sa.PrimaryKeyConstraint("object_id"),
        sa.UniqueConstraint(
            "organization_id", "user_id", name="unique_organization_membership_link_organization_user"
        ),
    )
    op.create_table(
        "project_latest",
        sa.Column("created_at", sa.DateTime(timezone=True), nullable=False),
        sa.Column("object_id", sa.String(), nullable=False),
        sa.Column("organization_id", sa.String(), nullable=False),
        sa.Column("name", sa.String(), nullable=False),
        sa.Column("user_git_repo_url", sa.String(), nullable=True),
        sa.Column("our_git_repo_url", sa.String(), nullable=True),
        sa.Column("is_loggable", sa.Integer(), nullable=False),
        sa.ForeignKeyConstraint(
            ["organization_id"], ["organization_latest.object_id"], name="foreign_key_organization_id"
        ),
        sa.PrimaryKeyConstraint("object_id"),
    )
    op.create_table(
        "task_latest",
        sa.Column("created_at", sa.DateTime(timezone=True), nullable=False),
        sa.Column("object_id", sa.String(), nullable=False),
        sa.Column("organization_id", sa.String(), nullable=False),
        sa.Column("user_id", sa.String(), nullable=False),
        sa.Column("project_id", sa.String(), nullable=False),
        sa.Column("parent_task_id", sa.String(), nullable=True),
        sa.Column("input_data", sa.JSON(), nullable=False),
        sa.Column("max_seconds", sa.Float(), nullable=True),
        sa.Column("current_state", sa.JSON(), nullable=True),
        sa.Column("outcome", sa.String(), nullable=False),
        sa.Column("error", sa.JSON(), nullable=True),
        sa.Column("is_archived", sa.Integer(), nullable=False),
        sa.Column("is_deleted", sa.Integer(), nullable=False),
        sa.ForeignKeyConstraint(
            ["organization_id"], ["organization_latest.object_id"], name="foreign_key_organization_id"
        ),
        sa.ForeignKeyConstraint(["parent_task_id"], ["task_latest.object_id"], name="foreign_key_parent_task_id"),
        sa.ForeignKeyConstraint(["project_id"], ["project_latest.object_id"], name="foreign_key_project_id"),
        sa.ForeignKeyConstraint(["user_id"], ["user_latest.object_id"], name="foreign_key_user_id"),
        sa.PrimaryKeyConstraint("object_id"),
    )
    op.create_table(
        "notification",
        sa.Column("snapshot_id", sa.String(), nullable=False),
        sa.Column("created_at", sa.DateTime(timezone=True), nullable=False),
        sa.Column("object_id", sa.String(), nullable=False),
        sa.Column("user_id", sa.String(), nullable=False),
        sa.Column("message", sa.String(), nullable=False),
        sa.Column("importance", sa.String(), nullable=False),
        sa.Column("task_id", sa.String(), nullable=True),
        sa.Column("url", sa.String(), nullable=True),
        sa.ForeignKeyConstraint(["task_id"], ["task_latest.object_id"], name="foreign_key_task_id"),
        sa.PrimaryKeyConstraint("snapshot_id"),
    )
    op.create_table(
        "saved_agent_message",
        sa.Column("snapshot_id", sa.String(), nullable=False),
        sa.Column("created_at", sa.DateTime(timezone=True), nullable=False),
        sa.Column("object_id", sa.String(), nullable=False),
        sa.Column("task_id", sa.String(), nullable=False),
        sa.Column("message", sa.JSON(), nullable=False),
        sa.Column("source", sa.String(), nullable=False),
        sa.Column("is_partial", sa.Integer(), nullable=False),
        sa.ForeignKeyConstraint(["task_id"], ["task_latest.object_id"], name="foreign_key_task_id"),
        sa.PrimaryKeyConstraint("snapshot_id"),
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    """Downgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table("saved_agent_message")
    op.drop_table("notification")
    op.drop_table("task_latest")
    op.drop_table("project_latest")
    op.drop_table("organization_membership_link_latest")
    op.drop_table("user_latest")
    op.drop_table("user")
    op.drop_table("task")
    op.drop_table("project")
    op.drop_table("organization_membership_link")
    op.drop_table("organization_latest")
    op.drop_table("organization")
    # ### end Alembic commands ###
